package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class QuietTime(
    end: Option[__string] = None,
    start: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.QuietTime = {
    import QuietTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.QuietTime
      .builder()
      .optionallyWith(
        end.map(value => __string.unwrap(value): java.lang.String)
      )(_.end)
      .optionallyWith(
        start.map(value => __string.unwrap(value): java.lang.String)
      )(_.start)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.QuietTime.ReadOnly =
    zio.aws.pinpoint.model.QuietTime.wrap(buildAwsValue())
}
object QuietTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.QuietTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.QuietTime = zio.aws.pinpoint.model
      .QuietTime(end.map(value => value), start.map(value => value))
    def end: Option[__string]
    def start: Option[__string]
    def getEnd: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("end", end)
    def getStart: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("start", start)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.QuietTime
  ) extends zio.aws.pinpoint.model.QuietTime.ReadOnly {
    override val end: Option[__string] = scala
      .Option(impl.end())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val start: Option[__string] = scala
      .Option(impl.start())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.QuietTime
  ): zio.aws.pinpoint.model.QuietTime.ReadOnly = new Wrapper(impl)
}
