package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class RandomSplitEntry(
    nextActivity: Option[__string] = None,
    percentage: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.RandomSplitEntry = {
    import RandomSplitEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.RandomSplitEntry
      .builder()
      .optionallyWith(
        nextActivity.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextActivity)
      .optionallyWith(
        percentage.map(value => __integer.unwrap(value): Integer)
      )(_.percentage)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.RandomSplitEntry.ReadOnly =
    zio.aws.pinpoint.model.RandomSplitEntry.wrap(buildAwsValue())
}
object RandomSplitEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.RandomSplitEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.RandomSplitEntry =
      zio.aws.pinpoint.model.RandomSplitEntry(
        nextActivity.map(value => value),
        percentage.map(value => value)
      )
    def nextActivity: Option[__string]
    def percentage: Option[__integer]
    def getNextActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextActivity", nextActivity)
    def getPercentage: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("percentage", percentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.RandomSplitEntry
  ) extends zio.aws.pinpoint.model.RandomSplitEntry.ReadOnly {
    override val nextActivity: Option[__string] = scala
      .Option(impl.nextActivity())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val percentage: Option[__integer] = scala
      .Option(impl.percentage())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.RandomSplitEntry
  ): zio.aws.pinpoint.model.RandomSplitEntry.ReadOnly = new Wrapper(impl)
}
