package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RecencyDimension(
    duration: zio.aws.pinpoint.model.Duration,
    recencyType: zio.aws.pinpoint.model.RecencyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.RecencyDimension = {
    import RecencyDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.RecencyDimension
      .builder()
      .duration(duration.unwrap)
      .recencyType(recencyType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.RecencyDimension.ReadOnly =
    zio.aws.pinpoint.model.RecencyDimension.wrap(buildAwsValue())
}
object RecencyDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.RecencyDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.RecencyDimension =
      zio.aws.pinpoint.model.RecencyDimension(duration, recencyType)
    def duration: zio.aws.pinpoint.model.Duration
    def recencyType: zio.aws.pinpoint.model.RecencyType
    def getDuration: ZIO[Any, Nothing, zio.aws.pinpoint.model.Duration] =
      ZIO.succeed(duration)
    def getRecencyType: ZIO[Any, Nothing, zio.aws.pinpoint.model.RecencyType] =
      ZIO.succeed(recencyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.RecencyDimension
  ) extends zio.aws.pinpoint.model.RecencyDimension.ReadOnly {
    override val duration: zio.aws.pinpoint.model.Duration =
      zio.aws.pinpoint.model.Duration.wrap(impl.duration())
    override val recencyType: zio.aws.pinpoint.model.RecencyType =
      zio.aws.pinpoint.model.RecencyType.wrap(impl.recencyType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.RecencyDimension
  ): zio.aws.pinpoint.model.RecencyDimension.ReadOnly = new Wrapper(impl)
}
