package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class RecommenderConfigurationResponse(
    attributes: Option[Map[__string, __string]] = None,
    creationDate: __string,
    description: Option[__string] = None,
    id: __string,
    lastModifiedDate: __string,
    name: Option[__string] = None,
    recommendationProviderIdType: Option[__string] = None,
    recommendationProviderRoleArn: __string,
    recommendationProviderUri: __string,
    recommendationTransformerUri: Option[__string] = None,
    recommendationsDisplayName: Option[__string] = None,
    recommendationsPerMessage: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.RecommenderConfigurationResponse = {
    import RecommenderConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.RecommenderConfigurationResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .creationDate(__string.unwrap(creationDate): java.lang.String)
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .id(__string.unwrap(id): java.lang.String)
      .lastModifiedDate(__string.unwrap(lastModifiedDate): java.lang.String)
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        recommendationProviderIdType.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.recommendationProviderIdType)
      .recommendationProviderRoleArn(
        __string.unwrap(recommendationProviderRoleArn): java.lang.String
      )
      .recommendationProviderUri(
        __string.unwrap(recommendationProviderUri): java.lang.String
      )
      .optionallyWith(
        recommendationTransformerUri.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.recommendationTransformerUri)
      .optionallyWith(
        recommendationsDisplayName.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.recommendationsDisplayName)
      .optionallyWith(
        recommendationsPerMessage.map(value => __integer.unwrap(value): Integer)
      )(_.recommendationsPerMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.RecommenderConfigurationResponse.ReadOnly =
    zio.aws.pinpoint.model.RecommenderConfigurationResponse
      .wrap(buildAwsValue())
}
object RecommenderConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.RecommenderConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.RecommenderConfigurationResponse =
      zio.aws.pinpoint.model.RecommenderConfigurationResponse(
        attributes.map(value => value),
        creationDate,
        description.map(value => value),
        id,
        lastModifiedDate,
        name.map(value => value),
        recommendationProviderIdType.map(value => value),
        recommendationProviderRoleArn,
        recommendationProviderUri,
        recommendationTransformerUri.map(value => value),
        recommendationsDisplayName.map(value => value),
        recommendationsPerMessage.map(value => value)
      )
    def attributes: Option[Map[__string, __string]]
    def creationDate: __string
    def description: Option[__string]
    def id: __string
    def lastModifiedDate: __string
    def name: Option[__string]
    def recommendationProviderIdType: Option[__string]
    def recommendationProviderRoleArn: __string
    def recommendationProviderUri: __string
    def recommendationTransformerUri: Option[__string]
    def recommendationsDisplayName: Option[__string]
    def recommendationsPerMessage: Option[__integer]
    def getAttributes: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getLastModifiedDate: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastModifiedDate)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getRecommendationProviderIdType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "recommendationProviderIdType",
        recommendationProviderIdType
      )
    def getRecommendationProviderRoleArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(recommendationProviderRoleArn)
    def getRecommendationProviderUri: ZIO[Any, Nothing, __string] =
      ZIO.succeed(recommendationProviderUri)
    def getRecommendationTransformerUri: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "recommendationTransformerUri",
        recommendationTransformerUri
      )
    def getRecommendationsDisplayName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "recommendationsDisplayName",
        recommendationsDisplayName
      )
    def getRecommendationsPerMessage: ZIO[Any, AwsError, __integer] = AwsError
      .unwrapOptionField("recommendationsPerMessage", recommendationsPerMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.RecommenderConfigurationResponse
  ) extends zio.aws.pinpoint.model.RecommenderConfigurationResponse.ReadOnly {
    override val attributes: Option[Map[__string, __string]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val creationDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.creationDate())
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val id: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.id())
    override val lastModifiedDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.lastModifiedDate())
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val recommendationProviderIdType: Option[__string] = scala
      .Option(impl.recommendationProviderIdType())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val recommendationProviderRoleArn: __string =
      zio.aws.pinpoint.model.primitives
        .__string(impl.recommendationProviderRoleArn())
    override val recommendationProviderUri: __string =
      zio.aws.pinpoint.model.primitives
        .__string(impl.recommendationProviderUri())
    override val recommendationTransformerUri: Option[__string] = scala
      .Option(impl.recommendationTransformerUri())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val recommendationsDisplayName: Option[__string] = scala
      .Option(impl.recommendationsDisplayName())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val recommendationsPerMessage: Option[__integer] = scala
      .Option(impl.recommendationsPerMessage())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.RecommenderConfigurationResponse
  ): zio.aws.pinpoint.model.RecommenderConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
