package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ResultRow(
    groupedBys: Iterable[zio.aws.pinpoint.model.ResultRowValue],
    values: Iterable[zio.aws.pinpoint.model.ResultRowValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ResultRow = {
    import ResultRow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ResultRow
      .builder()
      .groupedBys(groupedBys.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .values(values.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ResultRow.ReadOnly =
    zio.aws.pinpoint.model.ResultRow.wrap(buildAwsValue())
}
object ResultRow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ResultRow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ResultRow =
      zio.aws.pinpoint.model.ResultRow(
        groupedBys.map { item =>
          item.asEditable
        },
        values.map { item =>
          item.asEditable
        }
      )
    def groupedBys: List[zio.aws.pinpoint.model.ResultRowValue.ReadOnly]
    def values: List[zio.aws.pinpoint.model.ResultRowValue.ReadOnly]
    def getGroupedBys: ZIO[Any, Nothing, List[
      zio.aws.pinpoint.model.ResultRowValue.ReadOnly
    ]] = ZIO.succeed(groupedBys)
    def getValues: ZIO[Any, Nothing, List[
      zio.aws.pinpoint.model.ResultRowValue.ReadOnly
    ]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ResultRow
  ) extends zio.aws.pinpoint.model.ResultRow.ReadOnly {
    override val groupedBys
        : List[zio.aws.pinpoint.model.ResultRowValue.ReadOnly] = impl
      .groupedBys()
      .asScala
      .map { item =>
        zio.aws.pinpoint.model.ResultRowValue.wrap(item)
      }
      .toList
    override val values: List[zio.aws.pinpoint.model.ResultRowValue.ReadOnly] =
      impl
        .values()
        .asScala
        .map { item =>
          zio.aws.pinpoint.model.ResultRowValue.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ResultRow
  ): zio.aws.pinpoint.model.ResultRow.ReadOnly = new Wrapper(impl)
}
