package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __boolean}
import scala.jdk.CollectionConverters.*
final case class SMSChannelRequest(
    enabled: Option[__boolean] = None,
    senderId: Option[__string] = None,
    shortCode: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest = {
    import SMSChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest
      .builder()
      .optionallyWith(
        enabled.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        senderId.map(value => __string.unwrap(value): java.lang.String)
      )(_.senderId)
      .optionallyWith(
        shortCode.map(value => __string.unwrap(value): java.lang.String)
      )(_.shortCode)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SMSChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.SMSChannelRequest.wrap(buildAwsValue())
}
object SMSChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SMSChannelRequest =
      zio.aws.pinpoint.model.SMSChannelRequest(
        enabled.map(value => value),
        senderId.map(value => value),
        shortCode.map(value => value)
      )
    def enabled: Option[__boolean]
    def senderId: Option[__string]
    def shortCode: Option[__string]
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getSenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("senderId", senderId)
    def getShortCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("shortCode", shortCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest
  ) extends zio.aws.pinpoint.model.SMSChannelRequest.ReadOnly {
    override val enabled: Option[__boolean] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val senderId: Option[__string] = scala
      .Option(impl.senderId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val shortCode: Option[__string] = scala
      .Option(impl.shortCode())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest
  ): zio.aws.pinpoint.model.SMSChannelRequest.ReadOnly = new Wrapper(impl)
}
