package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __boolean, __string}
import scala.jdk.CollectionConverters.*
final case class SMSChannelResponse(
    applicationId: Option[__string] = None,
    creationDate: Option[__string] = None,
    enabled: Option[__boolean] = None,
    hasCredential: Option[__boolean] = None,
    id: Option[__string] = None,
    isArchived: Option[__boolean] = None,
    lastModifiedBy: Option[__string] = None,
    lastModifiedDate: Option[__string] = None,
    platform: __string,
    promotionalMessagesPerSecond: Option[__integer] = None,
    senderId: Option[__string] = None,
    shortCode: Option[__string] = None,
    transactionalMessagesPerSecond: Option[__integer] = None,
    version: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SMSChannelResponse = {
    import SMSChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SMSChannelResponse
      .builder()
      .optionallyWith(
        applicationId.map(value => __string.unwrap(value): java.lang.String)
      )(_.applicationId)
      .optionallyWith(
        creationDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.creationDate)
      .optionallyWith(
        enabled.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .optionallyWith(
        hasCredential.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.hasCredential)
      .optionallyWith(
        id.map(value => __string.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        isArchived.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.isArchived)
      .optionallyWith(
        lastModifiedBy.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastModifiedBy)
      .optionallyWith(
        lastModifiedDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastModifiedDate)
      .platform(__string.unwrap(platform): java.lang.String)
      .optionallyWith(
        promotionalMessagesPerSecond.map(value =>
          __integer.unwrap(value): Integer
        )
      )(_.promotionalMessagesPerSecond)
      .optionallyWith(
        senderId.map(value => __string.unwrap(value): java.lang.String)
      )(_.senderId)
      .optionallyWith(
        shortCode.map(value => __string.unwrap(value): java.lang.String)
      )(_.shortCode)
      .optionallyWith(
        transactionalMessagesPerSecond.map(value =>
          __integer.unwrap(value): Integer
        )
      )(_.transactionalMessagesPerSecond)
      .optionallyWith(version.map(value => __integer.unwrap(value): Integer))(
        _.version
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SMSChannelResponse.ReadOnly =
    zio.aws.pinpoint.model.SMSChannelResponse.wrap(buildAwsValue())
}
object SMSChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SMSChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SMSChannelResponse =
      zio.aws.pinpoint.model.SMSChannelResponse(
        applicationId.map(value => value),
        creationDate.map(value => value),
        enabled.map(value => value),
        hasCredential.map(value => value),
        id.map(value => value),
        isArchived.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedDate.map(value => value),
        platform,
        promotionalMessagesPerSecond.map(value => value),
        senderId.map(value => value),
        shortCode.map(value => value),
        transactionalMessagesPerSecond.map(value => value),
        version.map(value => value)
      )
    def applicationId: Option[__string]
    def creationDate: Option[__string]
    def enabled: Option[__boolean]
    def hasCredential: Option[__boolean]
    def id: Option[__string]
    def isArchived: Option[__boolean]
    def lastModifiedBy: Option[__string]
    def lastModifiedDate: Option[__string]
    def platform: __string
    def promotionalMessagesPerSecond: Option[__integer]
    def senderId: Option[__string]
    def shortCode: Option[__string]
    def transactionalMessagesPerSecond: Option[__integer]
    def version: Option[__integer]
    def getApplicationId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getCreationDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getHasCredential: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("hasCredential", hasCredential)
    def getId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("id", id)
    def getIsArchived: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isArchived", isArchived)
    def getLastModifiedBy: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getPlatform: ZIO[Any, Nothing, __string] = ZIO.succeed(platform)
    def getPromotionalMessagesPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "promotionalMessagesPerSecond",
        promotionalMessagesPerSecond
      )
    def getSenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("senderId", senderId)
    def getShortCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("shortCode", shortCode)
    def getTransactionalMessagesPerSecond: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField(
        "transactionalMessagesPerSecond",
        transactionalMessagesPerSecond
      )
    def getVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSChannelResponse
  ) extends zio.aws.pinpoint.model.SMSChannelResponse.ReadOnly {
    override val applicationId: Option[__string] = scala
      .Option(impl.applicationId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val creationDate: Option[__string] = scala
      .Option(impl.creationDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val enabled: Option[__boolean] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val hasCredential: Option[__boolean] = scala
      .Option(impl.hasCredential())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val id: Option[__string] = scala
      .Option(impl.id())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val isArchived: Option[__boolean] = scala
      .Option(impl.isArchived())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val lastModifiedBy: Option[__string] = scala
      .Option(impl.lastModifiedBy())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val lastModifiedDate: Option[__string] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val platform: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.platform())
    override val promotionalMessagesPerSecond: Option[__integer] = scala
      .Option(impl.promotionalMessagesPerSecond())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val senderId: Option[__string] = scala
      .Option(impl.senderId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val shortCode: Option[__string] = scala
      .Option(impl.shortCode())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val transactionalMessagesPerSecond: Option[__integer] = scala
      .Option(impl.transactionalMessagesPerSecond())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val version: Option[__integer] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSChannelResponse
  ): zio.aws.pinpoint.model.SMSChannelResponse.ReadOnly = new Wrapper(impl)
}
