package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SMSMessage(
    body: Option[__string] = None,
    keyword: Option[__string] = None,
    mediaUrl: Option[__string] = None,
    messageType: Option[zio.aws.pinpoint.model.MessageType] = None,
    originationNumber: Option[__string] = None,
    senderId: Option[__string] = None,
    substitutions: Option[Map[__string, Iterable[__string]]] = None,
    entityId: Option[__string] = None,
    templateId: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SMSMessage = {
    import SMSMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SMSMessage
      .builder()
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(
        keyword.map(value => __string.unwrap(value): java.lang.String)
      )(_.keyword)
      .optionallyWith(
        mediaUrl.map(value => __string.unwrap(value): java.lang.String)
      )(_.mediaUrl)
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(
        originationNumber.map(value => __string.unwrap(value): java.lang.String)
      )(_.originationNumber)
      .optionallyWith(
        senderId.map(value => __string.unwrap(value): java.lang.String)
      )(_.senderId)
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.map { item =>
                __string.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(
        entityId.map(value => __string.unwrap(value): java.lang.String)
      )(_.entityId)
      .optionallyWith(
        templateId.map(value => __string.unwrap(value): java.lang.String)
      )(_.templateId)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SMSMessage.ReadOnly =
    zio.aws.pinpoint.model.SMSMessage.wrap(buildAwsValue())
}
object SMSMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SMSMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SMSMessage =
      zio.aws.pinpoint.model.SMSMessage(
        body.map(value => value),
        keyword.map(value => value),
        mediaUrl.map(value => value),
        messageType.map(value => value),
        originationNumber.map(value => value),
        senderId.map(value => value),
        substitutions.map(value => value),
        entityId.map(value => value),
        templateId.map(value => value)
      )
    def body: Option[__string]
    def keyword: Option[__string]
    def mediaUrl: Option[__string]
    def messageType: Option[zio.aws.pinpoint.model.MessageType]
    def originationNumber: Option[__string]
    def senderId: Option[__string]
    def substitutions: Option[Map[__string, List[__string]]]
    def entityId: Option[__string]
    def templateId: Option[__string]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getKeyword: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("keyword", keyword)
    def getMediaUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("mediaUrl", mediaUrl)
    def getMessageType: ZIO[Any, AwsError, zio.aws.pinpoint.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getOriginationNumber: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("originationNumber", originationNumber)
    def getSenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("senderId", senderId)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getEntityId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getTemplateId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateId", templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSMessage
  ) extends zio.aws.pinpoint.model.SMSMessage.ReadOnly {
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val keyword: Option[__string] = scala
      .Option(impl.keyword())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val mediaUrl: Option[__string] = scala
      .Option(impl.mediaUrl())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val messageType: Option[zio.aws.pinpoint.model.MessageType] = scala
      .Option(impl.messageType())
      .map(value => zio.aws.pinpoint.model.MessageType.wrap(value))
    override val originationNumber: Option[__string] = scala
      .Option(impl.originationNumber())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val senderId: Option[__string] = scala
      .Option(impl.senderId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val substitutions: Option[Map[__string, List[__string]]] = scala
      .Option(impl.substitutions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives
              .__string(key) -> value.asScala.map { item =>
              zio.aws.pinpoint.model.primitives.__string(item)
            }.toList
          })
          .toMap
      )
    override val entityId: Option[__string] = scala
      .Option(impl.entityId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateId: Option[__string] = scala
      .Option(impl.templateId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSMessage
  ): zio.aws.pinpoint.model.SMSMessage.ReadOnly = new Wrapper(impl)
}
