package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SMSTemplateRequest(
    body: Option[__string] = None,
    defaultSubstitutions: Option[__string] = None,
    recommenderId: Option[__string] = None,
    tags: Option[Map[__string, __string]] = None,
    templateDescription: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SMSTemplateRequest = {
    import SMSTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SMSTemplateRequest
      .builder()
      .optionallyWith(
        body.map(value => __string.unwrap(value): java.lang.String)
      )(_.body)
      .optionallyWith(
        defaultSubstitutions.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.defaultSubstitutions)
      .optionallyWith(
        recommenderId.map(value => __string.unwrap(value): java.lang.String)
      )(_.recommenderId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.templateDescription)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.SMSTemplateRequest.wrap(buildAwsValue())
}
object SMSTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SMSTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SMSTemplateRequest =
      zio.aws.pinpoint.model.SMSTemplateRequest(
        body.map(value => value),
        defaultSubstitutions.map(value => value),
        recommenderId.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value)
      )
    def body: Option[__string]
    def defaultSubstitutions: Option[__string]
    def recommenderId: Option[__string]
    def tags: Option[Map[__string, __string]]
    def templateDescription: Option[__string]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getRecommenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("recommenderId", recommenderId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSTemplateRequest
  ) extends zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly {
    override val body: Option[__string] = scala
      .Option(impl.body())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val defaultSubstitutions: Option[__string] = scala
      .Option(impl.defaultSubstitutions())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val recommenderId: Option[__string] = scala
      .Option(impl.recommenderId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val templateDescription: Option[__string] = scala
      .Option(impl.templateDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSTemplateRequest
  ): zio.aws.pinpoint.model.SMSTemplateRequest.ReadOnly = new Wrapper(impl)
}
