package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SegmentBehaviors(
    recency: Option[zio.aws.pinpoint.model.RecencyDimension] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentBehaviors = {
    import SegmentBehaviors.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentBehaviors
      .builder()
      .optionallyWith(recency.map(value => value.buildAwsValue()))(_.recency)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentBehaviors.ReadOnly =
    zio.aws.pinpoint.model.SegmentBehaviors.wrap(buildAwsValue())
}
object SegmentBehaviors {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentBehaviors
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentBehaviors =
      zio.aws.pinpoint.model
        .SegmentBehaviors(recency.map(value => value.asEditable))
    def recency: Option[zio.aws.pinpoint.model.RecencyDimension.ReadOnly]
    def getRecency
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.RecencyDimension.ReadOnly] =
      AwsError.unwrapOptionField("recency", recency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentBehaviors
  ) extends zio.aws.pinpoint.model.SegmentBehaviors.ReadOnly {
    override val recency
        : Option[zio.aws.pinpoint.model.RecencyDimension.ReadOnly] = scala
      .Option(impl.recency())
      .map(value => zio.aws.pinpoint.model.RecencyDimension.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentBehaviors
  ): zio.aws.pinpoint.model.SegmentBehaviors.ReadOnly = new Wrapper(impl)
}
