package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SegmentDemographics(
    appVersion: Option[zio.aws.pinpoint.model.SetDimension] = None,
    channel: Option[zio.aws.pinpoint.model.SetDimension] = None,
    deviceType: Option[zio.aws.pinpoint.model.SetDimension] = None,
    make: Option[zio.aws.pinpoint.model.SetDimension] = None,
    model: Option[zio.aws.pinpoint.model.SetDimension] = None,
    platform: Option[zio.aws.pinpoint.model.SetDimension] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentDemographics = {
    import SegmentDemographics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentDemographics
      .builder()
      .optionallyWith(appVersion.map(value => value.buildAwsValue()))(
        _.appVersion
      )
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .optionallyWith(deviceType.map(value => value.buildAwsValue()))(
        _.deviceType
      )
      .optionallyWith(make.map(value => value.buildAwsValue()))(_.make)
      .optionallyWith(model.map(value => value.buildAwsValue()))(_.model)
      .optionallyWith(platform.map(value => value.buildAwsValue()))(_.platform)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentDemographics.ReadOnly =
    zio.aws.pinpoint.model.SegmentDemographics.wrap(buildAwsValue())
}
object SegmentDemographics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentDemographics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentDemographics =
      zio.aws.pinpoint.model.SegmentDemographics(
        appVersion.map(value => value.asEditable),
        channel.map(value => value.asEditable),
        deviceType.map(value => value.asEditable),
        make.map(value => value.asEditable),
        model.map(value => value.asEditable),
        platform.map(value => value.asEditable)
      )
    def appVersion: Option[zio.aws.pinpoint.model.SetDimension.ReadOnly]
    def channel: Option[zio.aws.pinpoint.model.SetDimension.ReadOnly]
    def deviceType: Option[zio.aws.pinpoint.model.SetDimension.ReadOnly]
    def make: Option[zio.aws.pinpoint.model.SetDimension.ReadOnly]
    def model: Option[zio.aws.pinpoint.model.SetDimension.ReadOnly]
    def platform: Option[zio.aws.pinpoint.model.SetDimension.ReadOnly]
    def getAppVersion
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      AwsError.unwrapOptionField("appVersion", appVersion)
    def getChannel
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      AwsError.unwrapOptionField("channel", channel)
    def getDeviceType
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      AwsError.unwrapOptionField("deviceType", deviceType)
    def getMake
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      AwsError.unwrapOptionField("make", make)
    def getModel
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      AwsError.unwrapOptionField("model", model)
    def getPlatform
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      AwsError.unwrapOptionField("platform", platform)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentDemographics
  ) extends zio.aws.pinpoint.model.SegmentDemographics.ReadOnly {
    override val appVersion
        : Option[zio.aws.pinpoint.model.SetDimension.ReadOnly] = scala
      .Option(impl.appVersion())
      .map(value => zio.aws.pinpoint.model.SetDimension.wrap(value))
    override val channel: Option[zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      scala
        .Option(impl.channel())
        .map(value => zio.aws.pinpoint.model.SetDimension.wrap(value))
    override val deviceType
        : Option[zio.aws.pinpoint.model.SetDimension.ReadOnly] = scala
      .Option(impl.deviceType())
      .map(value => zio.aws.pinpoint.model.SetDimension.wrap(value))
    override val make: Option[zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      scala
        .Option(impl.make())
        .map(value => zio.aws.pinpoint.model.SetDimension.wrap(value))
    override val model: Option[zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      scala
        .Option(impl.model())
        .map(value => zio.aws.pinpoint.model.SetDimension.wrap(value))
    override val platform
        : Option[zio.aws.pinpoint.model.SetDimension.ReadOnly] = scala
      .Option(impl.platform())
      .map(value => zio.aws.pinpoint.model.SetDimension.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentDemographics
  ): zio.aws.pinpoint.model.SegmentDemographics.ReadOnly = new Wrapper(impl)
}
