package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SegmentDimensions(
    attributes: Option[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension]
    ] = None,
    behavior: Option[zio.aws.pinpoint.model.SegmentBehaviors] = None,
    demographic: Option[zio.aws.pinpoint.model.SegmentDemographics] = None,
    location: Option[zio.aws.pinpoint.model.SegmentLocation] = None,
    metrics: Option[Map[__string, zio.aws.pinpoint.model.MetricDimension]] =
      None,
    userAttributes: Option[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentDimensions = {
    import SegmentDimensions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentDimensions
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(behavior.map(value => value.buildAwsValue()))(_.behavior)
      .optionallyWith(demographic.map(value => value.buildAwsValue()))(
        _.demographic
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        metrics.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.metrics)
      .optionallyWith(
        userAttributes.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.userAttributes)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentDimensions.ReadOnly =
    zio.aws.pinpoint.model.SegmentDimensions.wrap(buildAwsValue())
}
object SegmentDimensions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentDimensions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentDimensions =
      zio.aws.pinpoint.model.SegmentDimensions(
        attributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        behavior.map(value => value.asEditable),
        demographic.map(value => value.asEditable),
        location.map(value => value.asEditable),
        metrics.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        userAttributes.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def attributes: Option[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension.ReadOnly]
    ]
    def behavior: Option[zio.aws.pinpoint.model.SegmentBehaviors.ReadOnly]
    def demographic: Option[zio.aws.pinpoint.model.SegmentDemographics.ReadOnly]
    def location: Option[zio.aws.pinpoint.model.SegmentLocation.ReadOnly]
    def metrics
        : Option[Map[__string, zio.aws.pinpoint.model.MetricDimension.ReadOnly]]
    def userAttributes: Option[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension.ReadOnly]
    ]
    def getAttributes: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.AttributeDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getBehavior
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SegmentBehaviors.ReadOnly] =
      AwsError.unwrapOptionField("behavior", behavior)
    def getDemographic: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.SegmentDemographics.ReadOnly
    ] = AwsError.unwrapOptionField("demographic", demographic)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SegmentLocation.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getMetrics: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.MetricDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metrics)
    def getUserAttributes: ZIO[Any, AwsError, Map[
      __string,
      zio.aws.pinpoint.model.AttributeDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("userAttributes", userAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentDimensions
  ) extends zio.aws.pinpoint.model.SegmentDimensions.ReadOnly {
    override val attributes: Option[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension.ReadOnly]
    ] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.AttributeDimension.wrap(value)
          })
          .toMap
      )
    override val behavior
        : Option[zio.aws.pinpoint.model.SegmentBehaviors.ReadOnly] = scala
      .Option(impl.behavior())
      .map(value => zio.aws.pinpoint.model.SegmentBehaviors.wrap(value))
    override val demographic
        : Option[zio.aws.pinpoint.model.SegmentDemographics.ReadOnly] = scala
      .Option(impl.demographic())
      .map(value => zio.aws.pinpoint.model.SegmentDemographics.wrap(value))
    override val location
        : Option[zio.aws.pinpoint.model.SegmentLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.pinpoint.model.SegmentLocation.wrap(value))
    override val metrics: Option[
      Map[__string, zio.aws.pinpoint.model.MetricDimension.ReadOnly]
    ] = scala
      .Option(impl.metrics())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.MetricDimension.wrap(value)
          })
          .toMap
      )
    override val userAttributes: Option[
      Map[__string, zio.aws.pinpoint.model.AttributeDimension.ReadOnly]
    ] = scala
      .Option(impl.userAttributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.AttributeDimension.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentDimensions
  ): zio.aws.pinpoint.model.SegmentDimensions.ReadOnly = new Wrapper(impl)
}
