package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SegmentGroup(
    dimensions: Option[Iterable[zio.aws.pinpoint.model.SegmentDimensions]] =
      None,
    sourceSegments: Option[Iterable[zio.aws.pinpoint.model.SegmentReference]] =
      None,
    sourceType: Option[zio.aws.pinpoint.model.SourceType] = None,
    `type`: Option[zio.aws.pinpoint.model.Type] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentGroup = {
    import SegmentGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentGroup
      .builder()
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(
        sourceSegments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceSegments)
      .optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentGroup.ReadOnly =
    zio.aws.pinpoint.model.SegmentGroup.wrap(buildAwsValue())
}
object SegmentGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentGroup =
      zio.aws.pinpoint.model.SegmentGroup(
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceSegments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceType.map(value => value),
        `type`.map(value => value)
      )
    def dimensions
        : Option[List[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly]]
    def sourceSegments
        : Option[List[zio.aws.pinpoint.model.SegmentReference.ReadOnly]]
    def sourceType: Option[zio.aws.pinpoint.model.SourceType]
    def `type`: Option[zio.aws.pinpoint.model.Type]
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.SegmentDimensions.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getSourceSegments: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.SegmentReference.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceSegments", sourceSegments)
    def getSourceType: ZIO[Any, AwsError, zio.aws.pinpoint.model.SourceType] =
      AwsError.unwrapOptionField("sourceType", sourceType)
    def getType: ZIO[Any, AwsError, zio.aws.pinpoint.model.Type] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentGroup
  ) extends zio.aws.pinpoint.model.SegmentGroup.ReadOnly {
    override val dimensions
        : Option[List[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly]] =
      scala
        .Option(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.SegmentDimensions.wrap(item)
          }.toList
        )
    override val sourceSegments
        : Option[List[zio.aws.pinpoint.model.SegmentReference.ReadOnly]] = scala
      .Option(impl.sourceSegments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpoint.model.SegmentReference.wrap(item)
        }.toList
      )
    override val sourceType: Option[zio.aws.pinpoint.model.SourceType] = scala
      .Option(impl.sourceType())
      .map(value => zio.aws.pinpoint.model.SourceType.wrap(value))
    override val `type`: Option[zio.aws.pinpoint.model.Type] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.pinpoint.model.Type.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentGroup
  ): zio.aws.pinpoint.model.SegmentGroup.ReadOnly = new Wrapper(impl)
}
