package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SegmentGroupList(
    groups: Option[Iterable[zio.aws.pinpoint.model.SegmentGroup]] = None,
    include: Option[zio.aws.pinpoint.model.Include] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentGroupList = {
    import SegmentGroupList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentGroupList
      .builder()
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(include.map(value => value.unwrap))(_.include)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentGroupList.ReadOnly =
    zio.aws.pinpoint.model.SegmentGroupList.wrap(buildAwsValue())
}
object SegmentGroupList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentGroupList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentGroupList =
      zio.aws.pinpoint.model.SegmentGroupList(
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        include.map(value => value)
      )
    def groups: Option[List[zio.aws.pinpoint.model.SegmentGroup.ReadOnly]]
    def include: Option[zio.aws.pinpoint.model.Include]
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.SegmentGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
    def getInclude: ZIO[Any, AwsError, zio.aws.pinpoint.model.Include] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentGroupList
  ) extends zio.aws.pinpoint.model.SegmentGroupList.ReadOnly {
    override val groups
        : Option[List[zio.aws.pinpoint.model.SegmentGroup.ReadOnly]] = scala
      .Option(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpoint.model.SegmentGroup.wrap(item)
        }.toList
      )
    override val include: Option[zio.aws.pinpoint.model.Include] = scala
      .Option(impl.include())
      .map(value => zio.aws.pinpoint.model.Include.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentGroupList
  ): zio.aws.pinpoint.model.SegmentGroupList.ReadOnly = new Wrapper(impl)
}
