package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class SegmentImportResource(
    channelCounts: Option[Map[__string, __integer]] = None,
    externalId: __string,
    format: zio.aws.pinpoint.model.Format,
    roleArn: __string,
    s3Url: __string,
    size: __integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentImportResource = {
    import SegmentImportResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentImportResource
      .builder()
      .optionallyWith(
        channelCounts.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__integer.unwrap(
                value
              ): Integer)
            })
            .asJava
        )
      )(_.channelCounts)
      .externalId(__string.unwrap(externalId): java.lang.String)
      .format(format.unwrap)
      .roleArn(__string.unwrap(roleArn): java.lang.String)
      .s3Url(__string.unwrap(s3Url): java.lang.String)
      .size(__integer.unwrap(size): Integer)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentImportResource.ReadOnly =
    zio.aws.pinpoint.model.SegmentImportResource.wrap(buildAwsValue())
}
object SegmentImportResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentImportResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentImportResource =
      zio.aws.pinpoint.model.SegmentImportResource(
        channelCounts.map(value => value),
        externalId,
        format,
        roleArn,
        s3Url,
        size
      )
    def channelCounts: Option[Map[__string, __integer]]
    def externalId: __string
    def format: zio.aws.pinpoint.model.Format
    def roleArn: __string
    def s3Url: __string
    def size: __integer
    def getChannelCounts: ZIO[Any, AwsError, Map[__string, __integer]] =
      AwsError.unwrapOptionField("channelCounts", channelCounts)
    def getExternalId: ZIO[Any, Nothing, __string] = ZIO.succeed(externalId)
    def getFormat: ZIO[Any, Nothing, zio.aws.pinpoint.model.Format] =
      ZIO.succeed(format)
    def getRoleArn: ZIO[Any, Nothing, __string] = ZIO.succeed(roleArn)
    def getS3Url: ZIO[Any, Nothing, __string] = ZIO.succeed(s3Url)
    def getSize: ZIO[Any, Nothing, __integer] = ZIO.succeed(size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentImportResource
  ) extends zio.aws.pinpoint.model.SegmentImportResource.ReadOnly {
    override val channelCounts: Option[Map[__string, __integer]] = scala
      .Option(impl.channelCounts())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__integer(value)
          })
          .toMap
      )
    override val externalId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.externalId())
    override val format: zio.aws.pinpoint.model.Format =
      zio.aws.pinpoint.model.Format.wrap(impl.format())
    override val roleArn: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.roleArn())
    override val s3Url: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.s3Url())
    override val size: __integer =
      zio.aws.pinpoint.model.primitives.__integer(impl.size())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentImportResource
  ): zio.aws.pinpoint.model.SegmentImportResource.ReadOnly = new Wrapper(impl)
}
