package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SegmentLocation(
    country: Option[zio.aws.pinpoint.model.SetDimension] = None,
    gpsPoint: Option[zio.aws.pinpoint.model.GPSPointDimension] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentLocation = {
    import SegmentLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentLocation
      .builder()
      .optionallyWith(country.map(value => value.buildAwsValue()))(_.country)
      .optionallyWith(gpsPoint.map(value => value.buildAwsValue()))(_.gpsPoint)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentLocation.ReadOnly =
    zio.aws.pinpoint.model.SegmentLocation.wrap(buildAwsValue())
}
object SegmentLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentLocation =
      zio.aws.pinpoint.model.SegmentLocation(
        country.map(value => value.asEditable),
        gpsPoint.map(value => value.asEditable)
      )
    def country: Option[zio.aws.pinpoint.model.SetDimension.ReadOnly]
    def gpsPoint: Option[zio.aws.pinpoint.model.GPSPointDimension.ReadOnly]
    def getCountry
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      AwsError.unwrapOptionField("country", country)
    def getGpsPoint: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.GPSPointDimension.ReadOnly
    ] = AwsError.unwrapOptionField("gpsPoint", gpsPoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentLocation
  ) extends zio.aws.pinpoint.model.SegmentLocation.ReadOnly {
    override val country: Option[zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      scala
        .Option(impl.country())
        .map(value => zio.aws.pinpoint.model.SetDimension.wrap(value))
    override val gpsPoint
        : Option[zio.aws.pinpoint.model.GPSPointDimension.ReadOnly] = scala
      .Option(impl.gpsPoint())
      .map(value => zio.aws.pinpoint.model.GPSPointDimension.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentLocation
  ): zio.aws.pinpoint.model.SegmentLocation.ReadOnly = new Wrapper(impl)
}
