package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class SegmentReference(
    id: __string,
    version: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentReference = {
    import SegmentReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentReference
      .builder()
      .id(__string.unwrap(id): java.lang.String)
      .optionallyWith(version.map(value => __integer.unwrap(value): Integer))(
        _.version
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentReference.ReadOnly =
    zio.aws.pinpoint.model.SegmentReference.wrap(buildAwsValue())
}
object SegmentReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentReference =
      zio.aws.pinpoint.model.SegmentReference(id, version.map(value => value))
    def id: __string
    def version: Option[__integer]
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentReference
  ) extends zio.aws.pinpoint.model.SegmentReference.ReadOnly {
    override val id: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.id())
    override val version: Option[__integer] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentReference
  ): zio.aws.pinpoint.model.SegmentReference.ReadOnly = new Wrapper(impl)
}
