package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class SegmentResponse(
    applicationId: __string,
    arn: __string,
    creationDate: __string,
    dimensions: Option[zio.aws.pinpoint.model.SegmentDimensions] = None,
    id: __string,
    importDefinition: Option[zio.aws.pinpoint.model.SegmentImportResource] =
      None,
    lastModifiedDate: Option[__string] = None,
    name: Option[__string] = None,
    segmentGroups: Option[zio.aws.pinpoint.model.SegmentGroupList] = None,
    segmentType: zio.aws.pinpoint.model.SegmentType,
    tags: Option[Map[__string, __string]] = None,
    version: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentResponse = {
    import SegmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentResponse
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .arn(__string.unwrap(arn): java.lang.String)
      .creationDate(__string.unwrap(creationDate): java.lang.String)
      .optionallyWith(dimensions.map(value => value.buildAwsValue()))(
        _.dimensions
      )
      .id(__string.unwrap(id): java.lang.String)
      .optionallyWith(importDefinition.map(value => value.buildAwsValue()))(
        _.importDefinition
      )
      .optionallyWith(
        lastModifiedDate.map(value => __string.unwrap(value): java.lang.String)
      )(_.lastModifiedDate)
      .optionallyWith(
        name.map(value => __string.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(segmentGroups.map(value => value.buildAwsValue()))(
        _.segmentGroups
      )
      .segmentType(segmentType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(version.map(value => __integer.unwrap(value): Integer))(
        _.version
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentResponse.ReadOnly =
    zio.aws.pinpoint.model.SegmentResponse.wrap(buildAwsValue())
}
object SegmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentResponse =
      zio.aws.pinpoint.model.SegmentResponse(
        applicationId,
        arn,
        creationDate,
        dimensions.map(value => value.asEditable),
        id,
        importDefinition.map(value => value.asEditable),
        lastModifiedDate.map(value => value),
        name.map(value => value),
        segmentGroups.map(value => value.asEditable),
        segmentType,
        tags.map(value => value),
        version.map(value => value)
      )
    def applicationId: __string
    def arn: __string
    def creationDate: __string
    def dimensions: Option[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly]
    def id: __string
    def importDefinition
        : Option[zio.aws.pinpoint.model.SegmentImportResource.ReadOnly]
    def lastModifiedDate: Option[__string]
    def name: Option[__string]
    def segmentGroups: Option[zio.aws.pinpoint.model.SegmentGroupList.ReadOnly]
    def segmentType: zio.aws.pinpoint.model.SegmentType
    def tags: Option[Map[__string, __string]]
    def version: Option[__integer]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getDimensions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.SegmentDimensions.ReadOnly
    ] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getImportDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.SegmentImportResource.ReadOnly
    ] = AwsError.unwrapOptionField("importDefinition", importDefinition)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getSegmentGroups
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SegmentGroupList.ReadOnly] =
      AwsError.unwrapOptionField("segmentGroups", segmentGroups)
    def getSegmentType: ZIO[Any, Nothing, zio.aws.pinpoint.model.SegmentType] =
      ZIO.succeed(segmentType)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentResponse
  ) extends zio.aws.pinpoint.model.SegmentResponse.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val arn: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.arn())
    override val creationDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.creationDate())
    override val dimensions
        : Option[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly] = scala
      .Option(impl.dimensions())
      .map(value => zio.aws.pinpoint.model.SegmentDimensions.wrap(value))
    override val id: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.id())
    override val importDefinition
        : Option[zio.aws.pinpoint.model.SegmentImportResource.ReadOnly] = scala
      .Option(impl.importDefinition())
      .map(value => zio.aws.pinpoint.model.SegmentImportResource.wrap(value))
    override val lastModifiedDate: Option[__string] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val name: Option[__string] = scala
      .Option(impl.name())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val segmentGroups
        : Option[zio.aws.pinpoint.model.SegmentGroupList.ReadOnly] = scala
      .Option(impl.segmentGroups())
      .map(value => zio.aws.pinpoint.model.SegmentGroupList.wrap(value))
    override val segmentType: zio.aws.pinpoint.model.SegmentType =
      zio.aws.pinpoint.model.SegmentType.wrap(impl.segmentType())
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val version: Option[__integer] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentResponse
  ): zio.aws.pinpoint.model.SegmentResponse.ReadOnly = new Wrapper(impl)
}
