package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __integer}
import scala.jdk.CollectionConverters.*
final case class SendOTPMessageRequestParameters(
    allowedAttempts: Option[__integer] = None,
    brandName: __string,
    channel: __string,
    codeLength: Option[__integer] = None,
    destinationIdentity: __string,
    entityId: Option[__string] = None,
    language: Option[__string] = None,
    originationIdentity: __string,
    referenceId: __string,
    templateId: Option[__string] = None,
    validityPeriod: Option[__integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SendOTPMessageRequestParameters = {
    import SendOTPMessageRequestParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SendOTPMessageRequestParameters
      .builder()
      .optionallyWith(
        allowedAttempts.map(value => __integer.unwrap(value): Integer)
      )(_.allowedAttempts)
      .brandName(__string.unwrap(brandName): java.lang.String)
      .channel(__string.unwrap(channel): java.lang.String)
      .optionallyWith(
        codeLength.map(value => __integer.unwrap(value): Integer)
      )(_.codeLength)
      .destinationIdentity(
        __string.unwrap(destinationIdentity): java.lang.String
      )
      .optionallyWith(
        entityId.map(value => __string.unwrap(value): java.lang.String)
      )(_.entityId)
      .optionallyWith(
        language.map(value => __string.unwrap(value): java.lang.String)
      )(_.language)
      .originationIdentity(
        __string.unwrap(originationIdentity): java.lang.String
      )
      .referenceId(__string.unwrap(referenceId): java.lang.String)
      .optionallyWith(
        templateId.map(value => __string.unwrap(value): java.lang.String)
      )(_.templateId)
      .optionallyWith(
        validityPeriod.map(value => __integer.unwrap(value): Integer)
      )(_.validityPeriod)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.SendOTPMessageRequestParameters.ReadOnly =
    zio.aws.pinpoint.model.SendOTPMessageRequestParameters.wrap(buildAwsValue())
}
object SendOTPMessageRequestParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SendOTPMessageRequestParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SendOTPMessageRequestParameters =
      zio.aws.pinpoint.model.SendOTPMessageRequestParameters(
        allowedAttempts.map(value => value),
        brandName,
        channel,
        codeLength.map(value => value),
        destinationIdentity,
        entityId.map(value => value),
        language.map(value => value),
        originationIdentity,
        referenceId,
        templateId.map(value => value),
        validityPeriod.map(value => value)
      )
    def allowedAttempts: Option[__integer]
    def brandName: __string
    def channel: __string
    def codeLength: Option[__integer]
    def destinationIdentity: __string
    def entityId: Option[__string]
    def language: Option[__string]
    def originationIdentity: __string
    def referenceId: __string
    def templateId: Option[__string]
    def validityPeriod: Option[__integer]
    def getAllowedAttempts: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("allowedAttempts", allowedAttempts)
    def getBrandName: ZIO[Any, Nothing, __string] = ZIO.succeed(brandName)
    def getChannel: ZIO[Any, Nothing, __string] = ZIO.succeed(channel)
    def getCodeLength: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("codeLength", codeLength)
    def getDestinationIdentity: ZIO[Any, Nothing, __string] =
      ZIO.succeed(destinationIdentity)
    def getEntityId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getLanguage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("language", language)
    def getOriginationIdentity: ZIO[Any, Nothing, __string] =
      ZIO.succeed(originationIdentity)
    def getReferenceId: ZIO[Any, Nothing, __string] = ZIO.succeed(referenceId)
    def getTemplateId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateId", templateId)
    def getValidityPeriod: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("validityPeriod", validityPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SendOTPMessageRequestParameters
  ) extends zio.aws.pinpoint.model.SendOTPMessageRequestParameters.ReadOnly {
    override val allowedAttempts: Option[__integer] = scala
      .Option(impl.allowedAttempts())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val brandName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.brandName())
    override val channel: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.channel())
    override val codeLength: Option[__integer] = scala
      .Option(impl.codeLength())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val destinationIdentity: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.destinationIdentity())
    override val entityId: Option[__string] = scala
      .Option(impl.entityId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val language: Option[__string] = scala
      .Option(impl.language())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val originationIdentity: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.originationIdentity())
    override val referenceId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.referenceId())
    override val templateId: Option[__string] = scala
      .Option(impl.templateId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val validityPeriod: Option[__integer] = scala
      .Option(impl.validityPeriod())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SendOTPMessageRequestParameters
  ): zio.aws.pinpoint.model.SendOTPMessageRequestParameters.ReadOnly =
    new Wrapper(impl)
}
