package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SendOtpMessageRequest(
    applicationId: __string,
    sendOTPMessageRequestParameters: zio.aws.pinpoint.model.SendOTPMessageRequestParameters
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SendOtpMessageRequest = {
    import SendOtpMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SendOtpMessageRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .sendOTPMessageRequestParameters(
        sendOTPMessageRequestParameters.buildAwsValue()
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SendOtpMessageRequest.ReadOnly =
    zio.aws.pinpoint.model.SendOtpMessageRequest.wrap(buildAwsValue())
}
object SendOtpMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SendOtpMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SendOtpMessageRequest =
      zio.aws.pinpoint.model.SendOtpMessageRequest(
        applicationId,
        sendOTPMessageRequestParameters.asEditable
      )
    def applicationId: __string
    def sendOTPMessageRequestParameters
        : zio.aws.pinpoint.model.SendOTPMessageRequestParameters.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getSendOTPMessageRequestParameters: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.SendOTPMessageRequestParameters.ReadOnly
    ] = ZIO.succeed(sendOTPMessageRequestParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SendOtpMessageRequest
  ) extends zio.aws.pinpoint.model.SendOtpMessageRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val sendOTPMessageRequestParameters
        : zio.aws.pinpoint.model.SendOTPMessageRequestParameters.ReadOnly =
      zio.aws.pinpoint.model.SendOTPMessageRequestParameters
        .wrap(impl.sendOTPMessageRequestParameters())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SendOtpMessageRequest
  ): zio.aws.pinpoint.model.SendOtpMessageRequest.ReadOnly = new Wrapper(impl)
}
