package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SendUsersMessageResponse(
    applicationId: __string,
    requestId: Option[__string] = None,
    result: Option[
      Map[__string, Map[__string, zio.aws.pinpoint.model.EndpointMessageResult]]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SendUsersMessageResponse = {
    import SendUsersMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SendUsersMessageResponse
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .optionallyWith(
        requestId.map(value => __string.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        result.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> value
                .map({ case (key, value) =>
                  (__string.unwrap(key): java.lang.String) -> value
                    .buildAwsValue()
                })
                .asJava
            })
            .asJava
        )
      )(_.result)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SendUsersMessageResponse.ReadOnly =
    zio.aws.pinpoint.model.SendUsersMessageResponse.wrap(buildAwsValue())
}
object SendUsersMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SendUsersMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SendUsersMessageResponse =
      zio.aws.pinpoint.model.SendUsersMessageResponse(
        applicationId,
        requestId.map(value => value),
        result.map(value =>
          value.map({ case (key, value) =>
            key -> value.map({ case (key, value) =>
              key -> value.asEditable
            })
          })
        )
      )
    def applicationId: __string
    def requestId: Option[__string]
    def result: Option[Map[
      __string,
      Map[__string, zio.aws.pinpoint.model.EndpointMessageResult.ReadOnly]
    ]]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getRequestId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getResult: ZIO[Any, AwsError, Map[
      __string,
      Map[__string, zio.aws.pinpoint.model.EndpointMessageResult.ReadOnly]
    ]] = AwsError.unwrapOptionField("result", result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SendUsersMessageResponse
  ) extends zio.aws.pinpoint.model.SendUsersMessageResponse.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val requestId: Option[__string] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val result: Option[Map[
      __string,
      Map[__string, zio.aws.pinpoint.model.EndpointMessageResult.ReadOnly]
    ]] = scala
      .Option(impl.result())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(key) -> value.asScala
              .map({ case (key, value) =>
                zio.aws.pinpoint.model.primitives.__string(
                  key
                ) -> zio.aws.pinpoint.model.EndpointMessageResult.wrap(value)
              })
              .toMap
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SendUsersMessageResponse
  ): zio.aws.pinpoint.model.SendUsersMessageResponse.ReadOnly = new Wrapper(
    impl
  )
}
