package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SendUsersMessagesRequest(
    applicationId: __string,
    sendUsersMessageRequest: zio.aws.pinpoint.model.SendUsersMessageRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesRequest = {
    import SendUsersMessagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .sendUsersMessageRequest(sendUsersMessageRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SendUsersMessagesRequest.ReadOnly =
    zio.aws.pinpoint.model.SendUsersMessagesRequest.wrap(buildAwsValue())
}
object SendUsersMessagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SendUsersMessagesRequest =
      zio.aws.pinpoint.model.SendUsersMessagesRequest(
        applicationId,
        sendUsersMessageRequest.asEditable
      )
    def applicationId: __string
    def sendUsersMessageRequest
        : zio.aws.pinpoint.model.SendUsersMessageRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getSendUsersMessageRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.SendUsersMessageRequest.ReadOnly
    ] = ZIO.succeed(sendUsersMessageRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesRequest
  ) extends zio.aws.pinpoint.model.SendUsersMessagesRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val sendUsersMessageRequest
        : zio.aws.pinpoint.model.SendUsersMessageRequest.ReadOnly =
      zio.aws.pinpoint.model.SendUsersMessageRequest
        .wrap(impl.sendUsersMessageRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SendUsersMessagesRequest
  ): zio.aws.pinpoint.model.SendUsersMessagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
