package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __integer}
import scala.jdk.CollectionConverters.*
final case class Session(
    duration: Option[__integer] = None,
    id: __string,
    startTimestamp: __string,
    stopTimestamp: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.Session = {
    import Session.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.Session
      .builder()
      .optionallyWith(duration.map(value => __integer.unwrap(value): Integer))(
        _.duration
      )
      .id(__string.unwrap(id): java.lang.String)
      .startTimestamp(__string.unwrap(startTimestamp): java.lang.String)
      .optionallyWith(
        stopTimestamp.map(value => __string.unwrap(value): java.lang.String)
      )(_.stopTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.Session.ReadOnly =
    zio.aws.pinpoint.model.Session.wrap(buildAwsValue())
}
object Session {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.Session] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.Session =
      zio.aws.pinpoint.model.Session(
        duration.map(value => value),
        id,
        startTimestamp,
        stopTimestamp.map(value => value)
      )
    def duration: Option[__integer]
    def id: __string
    def startTimestamp: __string
    def stopTimestamp: Option[__string]
    def getDuration: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getStartTimestamp: ZIO[Any, Nothing, __string] =
      ZIO.succeed(startTimestamp)
    def getStopTimestamp: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("stopTimestamp", stopTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.Session
  ) extends zio.aws.pinpoint.model.Session.ReadOnly {
    override val duration: Option[__integer] = scala
      .Option(impl.duration())
      .map(value => zio.aws.pinpoint.model.primitives.__integer(value))
    override val id: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.id())
    override val startTimestamp: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.startTimestamp())
    override val stopTimestamp: Option[__string] = scala
      .Option(impl.stopTimestamp())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.Session
  ): zio.aws.pinpoint.model.Session.ReadOnly = new Wrapper(impl)
}
