package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SetDimension(
    dimensionType: Option[zio.aws.pinpoint.model.DimensionType] = None,
    values: Iterable[__string]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SetDimension = {
    import SetDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SetDimension
      .builder()
      .optionallyWith(dimensionType.map(value => value.unwrap))(_.dimensionType)
      .values(values.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SetDimension.ReadOnly =
    zio.aws.pinpoint.model.SetDimension.wrap(buildAwsValue())
}
object SetDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SetDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SetDimension = zio.aws.pinpoint.model
      .SetDimension(dimensionType.map(value => value), values)
    def dimensionType: Option[zio.aws.pinpoint.model.DimensionType]
    def values: List[__string]
    def getDimensionType
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.DimensionType] =
      AwsError.unwrapOptionField("dimensionType", dimensionType)
    def getValues: ZIO[Any, Nothing, List[__string]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SetDimension
  ) extends zio.aws.pinpoint.model.SetDimension.ReadOnly {
    override val dimensionType: Option[zio.aws.pinpoint.model.DimensionType] =
      scala
        .Option(impl.dimensionType())
        .map(value => zio.aws.pinpoint.model.DimensionType.wrap(value))
    override val values: List[__string] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.pinpoint.model.primitives.__string(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SetDimension
  ): zio.aws.pinpoint.model.SetDimension.ReadOnly = new Wrapper(impl)
}
