package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SimpleCondition(
    eventCondition: Option[zio.aws.pinpoint.model.EventCondition] = None,
    segmentCondition: Option[zio.aws.pinpoint.model.SegmentCondition] = None,
    segmentDimensions: Option[zio.aws.pinpoint.model.SegmentDimensions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SimpleCondition = {
    import SimpleCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SimpleCondition
      .builder()
      .optionallyWith(eventCondition.map(value => value.buildAwsValue()))(
        _.eventCondition
      )
      .optionallyWith(segmentCondition.map(value => value.buildAwsValue()))(
        _.segmentCondition
      )
      .optionallyWith(segmentDimensions.map(value => value.buildAwsValue()))(
        _.segmentDimensions
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SimpleCondition.ReadOnly =
    zio.aws.pinpoint.model.SimpleCondition.wrap(buildAwsValue())
}
object SimpleCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SimpleCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SimpleCondition =
      zio.aws.pinpoint.model.SimpleCondition(
        eventCondition.map(value => value.asEditable),
        segmentCondition.map(value => value.asEditable),
        segmentDimensions.map(value => value.asEditable)
      )
    def eventCondition: Option[zio.aws.pinpoint.model.EventCondition.ReadOnly]
    def segmentCondition
        : Option[zio.aws.pinpoint.model.SegmentCondition.ReadOnly]
    def segmentDimensions
        : Option[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly]
    def getEventCondition
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.EventCondition.ReadOnly] =
      AwsError.unwrapOptionField("eventCondition", eventCondition)
    def getSegmentCondition
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SegmentCondition.ReadOnly] =
      AwsError.unwrapOptionField("segmentCondition", segmentCondition)
    def getSegmentDimensions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.SegmentDimensions.ReadOnly
    ] = AwsError.unwrapOptionField("segmentDimensions", segmentDimensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SimpleCondition
  ) extends zio.aws.pinpoint.model.SimpleCondition.ReadOnly {
    override val eventCondition
        : Option[zio.aws.pinpoint.model.EventCondition.ReadOnly] = scala
      .Option(impl.eventCondition())
      .map(value => zio.aws.pinpoint.model.EventCondition.wrap(value))
    override val segmentCondition
        : Option[zio.aws.pinpoint.model.SegmentCondition.ReadOnly] = scala
      .Option(impl.segmentCondition())
      .map(value => zio.aws.pinpoint.model.SegmentCondition.wrap(value))
    override val segmentDimensions
        : Option[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly] = scala
      .Option(impl.segmentDimensions())
      .map(value => zio.aws.pinpoint.model.SegmentDimensions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SimpleCondition
  ): zio.aws.pinpoint.model.SimpleCondition.ReadOnly = new Wrapper(impl)
}
