package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class SimpleEmailPart(
    charset: Option[__string] = None,
    data: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SimpleEmailPart = {
    import SimpleEmailPart.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SimpleEmailPart
      .builder()
      .optionallyWith(
        charset.map(value => __string.unwrap(value): java.lang.String)
      )(_.charset)
      .optionallyWith(
        data.map(value => __string.unwrap(value): java.lang.String)
      )(_.data)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly =
    zio.aws.pinpoint.model.SimpleEmailPart.wrap(buildAwsValue())
}
object SimpleEmailPart {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SimpleEmailPart
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SimpleEmailPart =
      zio.aws.pinpoint.model
        .SimpleEmailPart(charset.map(value => value), data.map(value => value))
    def charset: Option[__string]
    def data: Option[__string]
    def getCharset: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("charset", charset)
    def getData: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SimpleEmailPart
  ) extends zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly {
    override val charset: Option[__string] = scala
      .Option(impl.charset())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val data: Option[__string] = scala
      .Option(impl.data())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SimpleEmailPart
  ): zio.aws.pinpoint.model.SimpleEmailPart.ReadOnly = new Wrapper(impl)
}
