package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait SourceType {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.SourceType
}
object SourceType {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.SourceType
  ): zio.aws.pinpoint.model.SourceType = value match {
    case software.amazon.awssdk.services.pinpoint.model.SourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.SourceType.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.pinpoint.model.SourceType.ANY =>
      val r = ANY
      r
    case software.amazon.awssdk.services.pinpoint.model.SourceType.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.SourceType =
      software.amazon.awssdk.services.pinpoint.model.SourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.pinpoint.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.SourceType =
      software.amazon.awssdk.services.pinpoint.model.SourceType.ALL
  }
  case object ANY extends zio.aws.pinpoint.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.SourceType =
      software.amazon.awssdk.services.pinpoint.model.SourceType.ANY
  }
  case object NONE extends zio.aws.pinpoint.model.SourceType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.SourceType =
      software.amazon.awssdk.services.pinpoint.model.SourceType.NONE
  }
}
