package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class StartCondition(
    description: Option[__string] = None,
    eventStartCondition: Option[zio.aws.pinpoint.model.EventStartCondition] =
      None,
    segmentStartCondition: Option[zio.aws.pinpoint.model.SegmentCondition] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.StartCondition = {
    import StartCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.StartCondition
      .builder()
      .optionallyWith(
        description.map(value => __string.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(eventStartCondition.map(value => value.buildAwsValue()))(
        _.eventStartCondition
      )
      .optionallyWith(
        segmentStartCondition.map(value => value.buildAwsValue())
      )(_.segmentStartCondition)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.StartCondition.ReadOnly =
    zio.aws.pinpoint.model.StartCondition.wrap(buildAwsValue())
}
object StartCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.StartCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.StartCondition =
      zio.aws.pinpoint.model.StartCondition(
        description.map(value => value),
        eventStartCondition.map(value => value.asEditable),
        segmentStartCondition.map(value => value.asEditable)
      )
    def description: Option[__string]
    def eventStartCondition
        : Option[zio.aws.pinpoint.model.EventStartCondition.ReadOnly]
    def segmentStartCondition
        : Option[zio.aws.pinpoint.model.SegmentCondition.ReadOnly]
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getEventStartCondition: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.EventStartCondition.ReadOnly
    ] = AwsError.unwrapOptionField("eventStartCondition", eventStartCondition)
    def getSegmentStartCondition
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SegmentCondition.ReadOnly] =
      AwsError.unwrapOptionField("segmentStartCondition", segmentStartCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.StartCondition
  ) extends zio.aws.pinpoint.model.StartCondition.ReadOnly {
    override val description: Option[__string] = scala
      .Option(impl.description())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val eventStartCondition
        : Option[zio.aws.pinpoint.model.EventStartCondition.ReadOnly] = scala
      .Option(impl.eventStartCondition())
      .map(value => zio.aws.pinpoint.model.EventStartCondition.wrap(value))
    override val segmentStartCondition
        : Option[zio.aws.pinpoint.model.SegmentCondition.ReadOnly] = scala
      .Option(impl.segmentStartCondition())
      .map(value => zio.aws.pinpoint.model.SegmentCondition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.StartCondition
  ): zio.aws.pinpoint.model.StartCondition.ReadOnly = new Wrapper(impl)
}
