package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: __string,
    tagsModel: zio.aws.pinpoint.model.TagsModel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TagResourceRequest
      .builder()
      .resourceArn(__string.unwrap(resourceArn): java.lang.String)
      .tagsModel(tagsModel.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TagResourceRequest.ReadOnly =
    zio.aws.pinpoint.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TagResourceRequest =
      zio.aws.pinpoint.model
        .TagResourceRequest(resourceArn, tagsModel.asEditable)
    def resourceArn: __string
    def tagsModel: zio.aws.pinpoint.model.TagsModel.ReadOnly
    def getResourceArn: ZIO[Any, Nothing, __string] = ZIO.succeed(resourceArn)
    def getTagsModel
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.TagsModel.ReadOnly] =
      ZIO.succeed(tagsModel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TagResourceRequest
  ) extends zio.aws.pinpoint.model.TagResourceRequest.ReadOnly {
    override val resourceArn: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.resourceArn())
    override val tagsModel: zio.aws.pinpoint.model.TagsModel.ReadOnly =
      zio.aws.pinpoint.model.TagsModel.wrap(impl.tagsModel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TagResourceRequest
  ): zio.aws.pinpoint.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
