package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class TagsModel(tags: Map[__string, __string]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TagsModel = {
    import TagsModel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TagsModel
      .builder()
      .tags(
        tags
          .map({ case (key, value) =>
            (__string.unwrap(key): java.lang.String) -> (__string
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TagsModel.ReadOnly =
    zio.aws.pinpoint.model.TagsModel.wrap(buildAwsValue())
}
object TagsModel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TagsModel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TagsModel =
      zio.aws.pinpoint.model.TagsModel(tags)
    def tags: Map[__string, __string]
    def getTags: ZIO[Any, Nothing, Map[__string, __string]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TagsModel
  ) extends zio.aws.pinpoint.model.TagsModel.ReadOnly {
    override val tags: Map[__string, __string] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.pinpoint.model.primitives
          .__string(key) -> zio.aws.pinpoint.model.primitives.__string(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TagsModel
  ): zio.aws.pinpoint.model.TagsModel.ReadOnly = new Wrapper(impl)
}
