package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TemplateConfiguration(
    emailTemplate: Option[zio.aws.pinpoint.model.Template] = None,
    pushTemplate: Option[zio.aws.pinpoint.model.Template] = None,
    smsTemplate: Option[zio.aws.pinpoint.model.Template] = None,
    voiceTemplate: Option[zio.aws.pinpoint.model.Template] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration = {
    import TemplateConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration
      .builder()
      .optionallyWith(emailTemplate.map(value => value.buildAwsValue()))(
        _.emailTemplate
      )
      .optionallyWith(pushTemplate.map(value => value.buildAwsValue()))(
        _.pushTemplate
      )
      .optionallyWith(smsTemplate.map(value => value.buildAwsValue()))(
        _.smsTemplate
      )
      .optionallyWith(voiceTemplate.map(value => value.buildAwsValue()))(
        _.voiceTemplate
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly =
    zio.aws.pinpoint.model.TemplateConfiguration.wrap(buildAwsValue())
}
object TemplateConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TemplateConfiguration =
      zio.aws.pinpoint.model.TemplateConfiguration(
        emailTemplate.map(value => value.asEditable),
        pushTemplate.map(value => value.asEditable),
        smsTemplate.map(value => value.asEditable),
        voiceTemplate.map(value => value.asEditable)
      )
    def emailTemplate: Option[zio.aws.pinpoint.model.Template.ReadOnly]
    def pushTemplate: Option[zio.aws.pinpoint.model.Template.ReadOnly]
    def smsTemplate: Option[zio.aws.pinpoint.model.Template.ReadOnly]
    def voiceTemplate: Option[zio.aws.pinpoint.model.Template.ReadOnly]
    def getEmailTemplate
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Template.ReadOnly] =
      AwsError.unwrapOptionField("emailTemplate", emailTemplate)
    def getPushTemplate
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Template.ReadOnly] =
      AwsError.unwrapOptionField("pushTemplate", pushTemplate)
    def getSmsTemplate
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Template.ReadOnly] =
      AwsError.unwrapOptionField("smsTemplate", smsTemplate)
    def getVoiceTemplate
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Template.ReadOnly] =
      AwsError.unwrapOptionField("voiceTemplate", voiceTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration
  ) extends zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly {
    override val emailTemplate
        : Option[zio.aws.pinpoint.model.Template.ReadOnly] = scala
      .Option(impl.emailTemplate())
      .map(value => zio.aws.pinpoint.model.Template.wrap(value))
    override val pushTemplate
        : Option[zio.aws.pinpoint.model.Template.ReadOnly] = scala
      .Option(impl.pushTemplate())
      .map(value => zio.aws.pinpoint.model.Template.wrap(value))
    override val smsTemplate: Option[zio.aws.pinpoint.model.Template.ReadOnly] =
      scala
        .Option(impl.smsTemplate())
        .map(value => zio.aws.pinpoint.model.Template.wrap(value))
    override val voiceTemplate
        : Option[zio.aws.pinpoint.model.Template.ReadOnly] = scala
      .Option(impl.voiceTemplate())
      .map(value => zio.aws.pinpoint.model.Template.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration
  ): zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly = new Wrapper(impl)
}
