package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class TemplateCreateMessageBody(
    arn: Option[__string] = None,
    message: Option[__string] = None,
    requestID: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TemplateCreateMessageBody = {
    import TemplateCreateMessageBody.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TemplateCreateMessageBody
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        message.map(value => __string.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        requestID.map(value => __string.unwrap(value): java.lang.String)
      )(_.requestID)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TemplateCreateMessageBody.ReadOnly =
    zio.aws.pinpoint.model.TemplateCreateMessageBody.wrap(buildAwsValue())
}
object TemplateCreateMessageBody {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TemplateCreateMessageBody
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TemplateCreateMessageBody =
      zio.aws.pinpoint.model.TemplateCreateMessageBody(
        arn.map(value => value),
        message.map(value => value),
        requestID.map(value => value)
      )
    def arn: Option[__string]
    def message: Option[__string]
    def requestID: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
    def getRequestID: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestID", requestID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateCreateMessageBody
  ) extends zio.aws.pinpoint.model.TemplateCreateMessageBody.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val message: Option[__string] = scala
      .Option(impl.message())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val requestID: Option[__string] = scala
      .Option(impl.requestID())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateCreateMessageBody
  ): zio.aws.pinpoint.model.TemplateCreateMessageBody.ReadOnly = new Wrapper(
    impl
  )
}
