package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class TemplateResponse(
    arn: Option[__string] = None,
    creationDate: __string,
    defaultSubstitutions: Option[__string] = None,
    lastModifiedDate: __string,
    tags: Option[Map[__string, __string]] = None,
    templateDescription: Option[__string] = None,
    templateName: __string,
    templateType: zio.aws.pinpoint.model.TemplateType,
    version: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TemplateResponse = {
    import TemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TemplateResponse
      .builder()
      .optionallyWith(
        arn.map(value => __string.unwrap(value): java.lang.String)
      )(_.arn)
      .creationDate(__string.unwrap(creationDate): java.lang.String)
      .optionallyWith(
        defaultSubstitutions.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.defaultSubstitutions)
      .lastModifiedDate(__string.unwrap(lastModifiedDate): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (__string.unwrap(key): java.lang.String) -> (__string.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.templateDescription)
      .templateName(__string.unwrap(templateName): java.lang.String)
      .templateType(templateType.unwrap)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TemplateResponse.ReadOnly =
    zio.aws.pinpoint.model.TemplateResponse.wrap(buildAwsValue())
}
object TemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TemplateResponse =
      zio.aws.pinpoint.model.TemplateResponse(
        arn.map(value => value),
        creationDate,
        defaultSubstitutions.map(value => value),
        lastModifiedDate,
        tags.map(value => value),
        templateDescription.map(value => value),
        templateName,
        templateType,
        version.map(value => value)
      )
    def arn: Option[__string]
    def creationDate: __string
    def defaultSubstitutions: Option[__string]
    def lastModifiedDate: __string
    def tags: Option[Map[__string, __string]]
    def templateDescription: Option[__string]
    def templateName: __string
    def templateType: zio.aws.pinpoint.model.TemplateType
    def version: Option[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getLastModifiedDate: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastModifiedDate)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.TemplateType] =
      ZIO.succeed(templateType)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateResponse
  ) extends zio.aws.pinpoint.model.TemplateResponse.ReadOnly {
    override val arn: Option[__string] = scala
      .Option(impl.arn())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val creationDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.creationDate())
    override val defaultSubstitutions: Option[__string] = scala
      .Option(impl.defaultSubstitutions())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val lastModifiedDate: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.lastModifiedDate())
    override val tags: Option[Map[__string, __string]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.pinpoint.model.primitives.__string(
              key
            ) -> zio.aws.pinpoint.model.primitives.__string(value)
          })
          .toMap
      )
    override val templateDescription: Option[__string] = scala
      .Option(impl.templateDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val templateType: zio.aws.pinpoint.model.TemplateType =
      zio.aws.pinpoint.model.TemplateType.wrap(impl.templateType())
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateResponse
  ): zio.aws.pinpoint.model.TemplateResponse.ReadOnly = new Wrapper(impl)
}
