package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class TemplateVersionsResponse(
    item: Iterable[zio.aws.pinpoint.model.TemplateVersionResponse],
    message: Option[__string] = None,
    nextToken: Option[__string] = None,
    requestID: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TemplateVersionsResponse = {
    import TemplateVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TemplateVersionsResponse
      .builder()
      .item(item.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        message.map(value => __string.unwrap(value): java.lang.String)
      )(_.message)
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        requestID.map(value => __string.unwrap(value): java.lang.String)
      )(_.requestID)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TemplateVersionsResponse.ReadOnly =
    zio.aws.pinpoint.model.TemplateVersionsResponse.wrap(buildAwsValue())
}
object TemplateVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TemplateVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TemplateVersionsResponse =
      zio.aws.pinpoint.model.TemplateVersionsResponse(
        item.map { item =>
          item.asEditable
        },
        message.map(value => value),
        nextToken.map(value => value),
        requestID.map(value => value)
      )
    def item: List[zio.aws.pinpoint.model.TemplateVersionResponse.ReadOnly]
    def message: Option[__string]
    def nextToken: Option[__string]
    def requestID: Option[__string]
    def getItem: ZIO[Any, Nothing, List[
      zio.aws.pinpoint.model.TemplateVersionResponse.ReadOnly
    ]] = ZIO.succeed(item)
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRequestID: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestID", requestID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateVersionsResponse
  ) extends zio.aws.pinpoint.model.TemplateVersionsResponse.ReadOnly {
    override val item
        : List[zio.aws.pinpoint.model.TemplateVersionResponse.ReadOnly] = impl
      .item()
      .asScala
      .map { item =>
        zio.aws.pinpoint.model.TemplateVersionResponse.wrap(item)
      }
      .toList
    override val message: Option[__string] = scala
      .Option(impl.message())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val requestID: Option[__string] = scala
      .Option(impl.requestID())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateVersionsResponse
  ): zio.aws.pinpoint.model.TemplateVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
