package zio.aws.pinpoint.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import scala.jdk.CollectionConverters.*
final case class TreatmentResource(
    customDeliveryConfiguration: Option[
      zio.aws.pinpoint.model.CustomDeliveryConfiguration
    ] = None,
    id: __string,
    messageConfiguration: Option[zio.aws.pinpoint.model.MessageConfiguration] =
      None,
    schedule: Option[zio.aws.pinpoint.model.Schedule] = None,
    sizePercent: __integer,
    state: Option[zio.aws.pinpoint.model.CampaignState] = None,
    templateConfiguration: Option[
      zio.aws.pinpoint.model.TemplateConfiguration
    ] = None,
    treatmentDescription: Option[__string] = None,
    treatmentName: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TreatmentResource = {
    import TreatmentResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TreatmentResource
      .builder()
      .optionallyWith(
        customDeliveryConfiguration.map(value => value.buildAwsValue())
      )(_.customDeliveryConfiguration)
      .id(__string.unwrap(id): java.lang.String)
      .optionallyWith(messageConfiguration.map(value => value.buildAwsValue()))(
        _.messageConfiguration
      )
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .sizePercent(__integer.unwrap(sizePercent): Integer)
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        templateConfiguration.map(value => value.buildAwsValue())
      )(_.templateConfiguration)
      .optionallyWith(
        treatmentDescription.map(value =>
          __string.unwrap(value): java.lang.String
        )
      )(_.treatmentDescription)
      .optionallyWith(
        treatmentName.map(value => __string.unwrap(value): java.lang.String)
      )(_.treatmentName)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TreatmentResource.ReadOnly =
    zio.aws.pinpoint.model.TreatmentResource.wrap(buildAwsValue())
}
object TreatmentResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TreatmentResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TreatmentResource =
      zio.aws.pinpoint.model.TreatmentResource(
        customDeliveryConfiguration.map(value => value.asEditable),
        id,
        messageConfiguration.map(value => value.asEditable),
        schedule.map(value => value.asEditable),
        sizePercent,
        state.map(value => value.asEditable),
        templateConfiguration.map(value => value.asEditable),
        treatmentDescription.map(value => value),
        treatmentName.map(value => value)
      )
    def customDeliveryConfiguration
        : Option[zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly]
    def id: __string
    def messageConfiguration
        : Option[zio.aws.pinpoint.model.MessageConfiguration.ReadOnly]
    def schedule: Option[zio.aws.pinpoint.model.Schedule.ReadOnly]
    def sizePercent: __integer
    def state: Option[zio.aws.pinpoint.model.CampaignState.ReadOnly]
    def templateConfiguration
        : Option[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly]
    def treatmentDescription: Option[__string]
    def treatmentName: Option[__string]
    def getCustomDeliveryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customDeliveryConfiguration",
      customDeliveryConfiguration
    )
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getMessageConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.MessageConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("messageConfiguration", messageConfiguration)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Schedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getSizePercent: ZIO[Any, Nothing, __integer] = ZIO.succeed(sizePercent)
    def getState
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.CampaignState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getTemplateConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("templateConfiguration", templateConfiguration)
    def getTreatmentDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentDescription", treatmentDescription)
    def getTreatmentName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("treatmentName", treatmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TreatmentResource
  ) extends zio.aws.pinpoint.model.TreatmentResource.ReadOnly {
    override val customDeliveryConfiguration
        : Option[zio.aws.pinpoint.model.CustomDeliveryConfiguration.ReadOnly] =
      scala
        .Option(impl.customDeliveryConfiguration())
        .map(value =>
          zio.aws.pinpoint.model.CustomDeliveryConfiguration.wrap(value)
        )
    override val id: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.id())
    override val messageConfiguration
        : Option[zio.aws.pinpoint.model.MessageConfiguration.ReadOnly] = scala
      .Option(impl.messageConfiguration())
      .map(value => zio.aws.pinpoint.model.MessageConfiguration.wrap(value))
    override val schedule: Option[zio.aws.pinpoint.model.Schedule.ReadOnly] =
      scala
        .Option(impl.schedule())
        .map(value => zio.aws.pinpoint.model.Schedule.wrap(value))
    override val sizePercent: __integer =
      zio.aws.pinpoint.model.primitives.__integer(impl.sizePercent())
    override val state: Option[zio.aws.pinpoint.model.CampaignState.ReadOnly] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.pinpoint.model.CampaignState.wrap(value))
    override val templateConfiguration
        : Option[zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly] = scala
      .Option(impl.templateConfiguration())
      .map(value => zio.aws.pinpoint.model.TemplateConfiguration.wrap(value))
    override val treatmentDescription: Option[__string] = scala
      .Option(impl.treatmentDescription())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
    override val treatmentName: Option[__string] = scala
      .Option(impl.treatmentName())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TreatmentResource
  ): zio.aws.pinpoint.model.TreatmentResource.ReadOnly = new Wrapper(impl)
}
