package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateApnsSandboxChannelRequest(
    apnsSandboxChannelRequest: zio.aws.pinpoint.model.APNSSandboxChannelRequest,
    applicationId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest = {
    import UpdateApnsSandboxChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest
      .builder()
      .apnsSandboxChannelRequest(apnsSandboxChannelRequest.buildAwsValue())
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.UpdateApnsSandboxChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateApnsSandboxChannelRequest.wrap(buildAwsValue())
}
object UpdateApnsSandboxChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateApnsSandboxChannelRequest =
      zio.aws.pinpoint.model.UpdateApnsSandboxChannelRequest(
        apnsSandboxChannelRequest.asEditable,
        applicationId
      )
    def apnsSandboxChannelRequest
        : zio.aws.pinpoint.model.APNSSandboxChannelRequest.ReadOnly
    def applicationId: __string
    def getApnsSandboxChannelRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.APNSSandboxChannelRequest.ReadOnly
    ] = ZIO.succeed(apnsSandboxChannelRequest)
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest
  ) extends zio.aws.pinpoint.model.UpdateApnsSandboxChannelRequest.ReadOnly {
    override val apnsSandboxChannelRequest
        : zio.aws.pinpoint.model.APNSSandboxChannelRequest.ReadOnly =
      zio.aws.pinpoint.model.APNSSandboxChannelRequest
        .wrap(impl.apnsSandboxChannelRequest())
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest
  ): zio.aws.pinpoint.model.UpdateApnsSandboxChannelRequest.ReadOnly =
    new Wrapper(impl)
}
