package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateApnsVoipSandboxChannelRequest(
    apnsVoipSandboxChannelRequest: zio.aws.pinpoint.model.APNSVoipSandboxChannelRequest,
    applicationId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest = {
    import UpdateApnsVoipSandboxChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest
      .builder()
      .apnsVoipSandboxChannelRequest(
        apnsVoipSandboxChannelRequest.buildAwsValue()
      )
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelRequest
      .wrap(buildAwsValue())
}
object UpdateApnsVoipSandboxChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelRequest =
      zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelRequest(
        apnsVoipSandboxChannelRequest.asEditable,
        applicationId
      )
    def apnsVoipSandboxChannelRequest
        : zio.aws.pinpoint.model.APNSVoipSandboxChannelRequest.ReadOnly
    def applicationId: __string
    def getApnsVoipSandboxChannelRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.APNSVoipSandboxChannelRequest.ReadOnly
    ] = ZIO.succeed(apnsVoipSandboxChannelRequest)
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest
  ) extends zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelRequest.ReadOnly {
    override val apnsVoipSandboxChannelRequest
        : zio.aws.pinpoint.model.APNSVoipSandboxChannelRequest.ReadOnly =
      zio.aws.pinpoint.model.APNSVoipSandboxChannelRequest
        .wrap(impl.apnsVoipSandboxChannelRequest())
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipSandboxChannelRequest
  ): zio.aws.pinpoint.model.UpdateApnsVoipSandboxChannelRequest.ReadOnly =
    new Wrapper(impl)
}
