package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateAttributesRequest(
    blacklist: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateAttributesRequest = {
    import UpdateAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateAttributesRequest
      .builder()
      .optionallyWith(
        blacklist.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.blacklist)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateAttributesRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateAttributesRequest.wrap(buildAwsValue())
}
object UpdateAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateAttributesRequest =
      zio.aws.pinpoint.model
        .UpdateAttributesRequest(blacklist.map(value => value))
    def blacklist: Option[List[__string]]
    def getBlacklist: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("blacklist", blacklist)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateAttributesRequest
  ) extends zio.aws.pinpoint.model.UpdateAttributesRequest.ReadOnly {
    override val blacklist: Option[List[__string]] = scala
      .Option(impl.blacklist())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpoint.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateAttributesRequest
  ): zio.aws.pinpoint.model.UpdateAttributesRequest.ReadOnly = new Wrapper(impl)
}
