package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateCampaignRequest(
    applicationId: __string,
    campaignId: __string,
    writeCampaignRequest: zio.aws.pinpoint.model.WriteCampaignRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest = {
    import UpdateCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .campaignId(__string.unwrap(campaignId): java.lang.String)
      .writeCampaignRequest(writeCampaignRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateCampaignRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateCampaignRequest.wrap(buildAwsValue())
}
object UpdateCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateCampaignRequest =
      zio.aws.pinpoint.model.UpdateCampaignRequest(
        applicationId,
        campaignId,
        writeCampaignRequest.asEditable
      )
    def applicationId: __string
    def campaignId: __string
    def writeCampaignRequest
        : zio.aws.pinpoint.model.WriteCampaignRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getCampaignId: ZIO[Any, Nothing, __string] = ZIO.succeed(campaignId)
    def getWriteCampaignRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.WriteCampaignRequest.ReadOnly
    ] = ZIO.succeed(writeCampaignRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest
  ) extends zio.aws.pinpoint.model.UpdateCampaignRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val campaignId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.campaignId())
    override val writeCampaignRequest
        : zio.aws.pinpoint.model.WriteCampaignRequest.ReadOnly =
      zio.aws.pinpoint.model.WriteCampaignRequest
        .wrap(impl.writeCampaignRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest
  ): zio.aws.pinpoint.model.UpdateCampaignRequest.ReadOnly = new Wrapper(impl)
}
