package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateEmailChannelRequest(
    applicationId: __string,
    emailChannelRequest: zio.aws.pinpoint.model.EmailChannelRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest = {
    import UpdateEmailChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .emailChannelRequest(emailChannelRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateEmailChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateEmailChannelRequest.wrap(buildAwsValue())
}
object UpdateEmailChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateEmailChannelRequest =
      zio.aws.pinpoint.model.UpdateEmailChannelRequest(
        applicationId,
        emailChannelRequest.asEditable
      )
    def applicationId: __string
    def emailChannelRequest: zio.aws.pinpoint.model.EmailChannelRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getEmailChannelRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.EmailChannelRequest.ReadOnly
    ] = ZIO.succeed(emailChannelRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest
  ) extends zio.aws.pinpoint.model.UpdateEmailChannelRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val emailChannelRequest
        : zio.aws.pinpoint.model.EmailChannelRequest.ReadOnly =
      zio.aws.pinpoint.model.EmailChannelRequest
        .wrap(impl.emailChannelRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest
  ): zio.aws.pinpoint.model.UpdateEmailChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
