package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateEmailChannelResponse(
    emailChannelResponse: zio.aws.pinpoint.model.EmailChannelResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse = {
    import UpdateEmailChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse
      .builder()
      .emailChannelResponse(emailChannelResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateEmailChannelResponse.ReadOnly =
    zio.aws.pinpoint.model.UpdateEmailChannelResponse.wrap(buildAwsValue())
}
object UpdateEmailChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateEmailChannelResponse =
      zio.aws.pinpoint.model
        .UpdateEmailChannelResponse(emailChannelResponse.asEditable)
    def emailChannelResponse
        : zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly
    def getEmailChannelResponse: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly
    ] = ZIO.succeed(emailChannelResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse
  ) extends zio.aws.pinpoint.model.UpdateEmailChannelResponse.ReadOnly {
    override val emailChannelResponse
        : zio.aws.pinpoint.model.EmailChannelResponse.ReadOnly =
      zio.aws.pinpoint.model.EmailChannelResponse
        .wrap(impl.emailChannelResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse
  ): zio.aws.pinpoint.model.UpdateEmailChannelResponse.ReadOnly = new Wrapper(
    impl
  )
}
