package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __boolean}
import scala.jdk.CollectionConverters.*
final case class UpdateEmailTemplateRequest(
    createNewVersion: Option[__boolean] = None,
    emailTemplateRequest: zio.aws.pinpoint.model.EmailTemplateRequest,
    templateName: __string,
    version: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateRequest = {
    import UpdateEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateRequest
      .builder()
      .optionallyWith(
        createNewVersion.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.createNewVersion)
      .emailTemplateRequest(emailTemplateRequest.buildAwsValue())
      .templateName(__string.unwrap(templateName): java.lang.String)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateEmailTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateEmailTemplateRequest.wrap(buildAwsValue())
}
object UpdateEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateEmailTemplateRequest =
      zio.aws.pinpoint.model.UpdateEmailTemplateRequest(
        createNewVersion.map(value => value),
        emailTemplateRequest.asEditable,
        templateName,
        version.map(value => value)
      )
    def createNewVersion: Option[__boolean]
    def emailTemplateRequest
        : zio.aws.pinpoint.model.EmailTemplateRequest.ReadOnly
    def templateName: __string
    def version: Option[__string]
    def getCreateNewVersion: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("createNewVersion", createNewVersion)
    def getEmailTemplateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.EmailTemplateRequest.ReadOnly
    ] = ZIO.succeed(emailTemplateRequest)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateRequest
  ) extends zio.aws.pinpoint.model.UpdateEmailTemplateRequest.ReadOnly {
    override val createNewVersion: Option[__boolean] = scala
      .Option(impl.createNewVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val emailTemplateRequest
        : zio.aws.pinpoint.model.EmailTemplateRequest.ReadOnly =
      zio.aws.pinpoint.model.EmailTemplateRequest
        .wrap(impl.emailTemplateRequest())
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEmailTemplateRequest
  ): zio.aws.pinpoint.model.UpdateEmailTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
