package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateEndpointsBatchRequest(
    applicationId: __string,
    endpointBatchRequest: zio.aws.pinpoint.model.EndpointBatchRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest = {
    import UpdateEndpointsBatchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .endpointBatchRequest(endpointBatchRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateEndpointsBatchRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateEndpointsBatchRequest.wrap(buildAwsValue())
}
object UpdateEndpointsBatchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateEndpointsBatchRequest =
      zio.aws.pinpoint.model.UpdateEndpointsBatchRequest(
        applicationId,
        endpointBatchRequest.asEditable
      )
    def applicationId: __string
    def endpointBatchRequest
        : zio.aws.pinpoint.model.EndpointBatchRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getEndpointBatchRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.EndpointBatchRequest.ReadOnly
    ] = ZIO.succeed(endpointBatchRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest
  ) extends zio.aws.pinpoint.model.UpdateEndpointsBatchRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val endpointBatchRequest
        : zio.aws.pinpoint.model.EndpointBatchRequest.ReadOnly =
      zio.aws.pinpoint.model.EndpointBatchRequest
        .wrap(impl.endpointBatchRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest
  ): zio.aws.pinpoint.model.UpdateEndpointsBatchRequest.ReadOnly = new Wrapper(
    impl
  )
}
