package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateEndpointsBatchResponse(
    messageBody: zio.aws.pinpoint.model.MessageBody
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse = {
    import UpdateEndpointsBatchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse
      .builder()
      .messageBody(messageBody.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateEndpointsBatchResponse.ReadOnly =
    zio.aws.pinpoint.model.UpdateEndpointsBatchResponse.wrap(buildAwsValue())
}
object UpdateEndpointsBatchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateEndpointsBatchResponse =
      zio.aws.pinpoint.model
        .UpdateEndpointsBatchResponse(messageBody.asEditable)
    def messageBody: zio.aws.pinpoint.model.MessageBody.ReadOnly
    def getMessageBody
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.MessageBody.ReadOnly] =
      ZIO.succeed(messageBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse
  ) extends zio.aws.pinpoint.model.UpdateEndpointsBatchResponse.ReadOnly {
    override val messageBody: zio.aws.pinpoint.model.MessageBody.ReadOnly =
      zio.aws.pinpoint.model.MessageBody.wrap(impl.messageBody())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse
  ): zio.aws.pinpoint.model.UpdateEndpointsBatchResponse.ReadOnly = new Wrapper(
    impl
  )
}
