package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateGcmChannelRequest(
    applicationId: __string,
    gcmChannelRequest: zio.aws.pinpoint.model.GCMChannelRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest = {
    import UpdateGcmChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .gcmChannelRequest(gcmChannelRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateGcmChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateGcmChannelRequest.wrap(buildAwsValue())
}
object UpdateGcmChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateGcmChannelRequest =
      zio.aws.pinpoint.model
        .UpdateGcmChannelRequest(applicationId, gcmChannelRequest.asEditable)
    def applicationId: __string
    def gcmChannelRequest: zio.aws.pinpoint.model.GCMChannelRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getGcmChannelRequest
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.GCMChannelRequest.ReadOnly] =
      ZIO.succeed(gcmChannelRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest
  ) extends zio.aws.pinpoint.model.UpdateGcmChannelRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val gcmChannelRequest
        : zio.aws.pinpoint.model.GCMChannelRequest.ReadOnly =
      zio.aws.pinpoint.model.GCMChannelRequest.wrap(impl.gcmChannelRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest
  ): zio.aws.pinpoint.model.UpdateGcmChannelRequest.ReadOnly = new Wrapper(impl)
}
