package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __boolean}
import scala.jdk.CollectionConverters.*
final case class UpdateInAppTemplateRequest(
    createNewVersion: Option[__boolean] = None,
    inAppTemplateRequest: zio.aws.pinpoint.model.InAppTemplateRequest,
    templateName: __string,
    version: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateInAppTemplateRequest = {
    import UpdateInAppTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateInAppTemplateRequest
      .builder()
      .optionallyWith(
        createNewVersion.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.createNewVersion)
      .inAppTemplateRequest(inAppTemplateRequest.buildAwsValue())
      .templateName(__string.unwrap(templateName): java.lang.String)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateInAppTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateInAppTemplateRequest.wrap(buildAwsValue())
}
object UpdateInAppTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateInAppTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateInAppTemplateRequest =
      zio.aws.pinpoint.model.UpdateInAppTemplateRequest(
        createNewVersion.map(value => value),
        inAppTemplateRequest.asEditable,
        templateName,
        version.map(value => value)
      )
    def createNewVersion: Option[__boolean]
    def inAppTemplateRequest
        : zio.aws.pinpoint.model.InAppTemplateRequest.ReadOnly
    def templateName: __string
    def version: Option[__string]
    def getCreateNewVersion: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("createNewVersion", createNewVersion)
    def getInAppTemplateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.InAppTemplateRequest.ReadOnly
    ] = ZIO.succeed(inAppTemplateRequest)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateInAppTemplateRequest
  ) extends zio.aws.pinpoint.model.UpdateInAppTemplateRequest.ReadOnly {
    override val createNewVersion: Option[__boolean] = scala
      .Option(impl.createNewVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val inAppTemplateRequest
        : zio.aws.pinpoint.model.InAppTemplateRequest.ReadOnly =
      zio.aws.pinpoint.model.InAppTemplateRequest
        .wrap(impl.inAppTemplateRequest())
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateInAppTemplateRequest
  ): zio.aws.pinpoint.model.UpdateInAppTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
