package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateJourneyRequest(
    applicationId: __string,
    journeyId: __string,
    writeJourneyRequest: zio.aws.pinpoint.model.WriteJourneyRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateJourneyRequest = {
    import UpdateJourneyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateJourneyRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .journeyId(__string.unwrap(journeyId): java.lang.String)
      .writeJourneyRequest(writeJourneyRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateJourneyRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateJourneyRequest.wrap(buildAwsValue())
}
object UpdateJourneyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateJourneyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateJourneyRequest =
      zio.aws.pinpoint.model.UpdateJourneyRequest(
        applicationId,
        journeyId,
        writeJourneyRequest.asEditable
      )
    def applicationId: __string
    def journeyId: __string
    def writeJourneyRequest: zio.aws.pinpoint.model.WriteJourneyRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getJourneyId: ZIO[Any, Nothing, __string] = ZIO.succeed(journeyId)
    def getWriteJourneyRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.WriteJourneyRequest.ReadOnly
    ] = ZIO.succeed(writeJourneyRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateJourneyRequest
  ) extends zio.aws.pinpoint.model.UpdateJourneyRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val journeyId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.journeyId())
    override val writeJourneyRequest
        : zio.aws.pinpoint.model.WriteJourneyRequest.ReadOnly =
      zio.aws.pinpoint.model.WriteJourneyRequest
        .wrap(impl.writeJourneyRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateJourneyRequest
  ): zio.aws.pinpoint.model.UpdateJourneyRequest.ReadOnly = new Wrapper(impl)
}
