package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateJourneyStateRequest(
    applicationId: __string,
    journeyId: __string,
    journeyStateRequest: zio.aws.pinpoint.model.JourneyStateRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateRequest = {
    import UpdateJourneyStateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .journeyId(__string.unwrap(journeyId): java.lang.String)
      .journeyStateRequest(journeyStateRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateJourneyStateRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateJourneyStateRequest.wrap(buildAwsValue())
}
object UpdateJourneyStateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateJourneyStateRequest =
      zio.aws.pinpoint.model.UpdateJourneyStateRequest(
        applicationId,
        journeyId,
        journeyStateRequest.asEditable
      )
    def applicationId: __string
    def journeyId: __string
    def journeyStateRequest: zio.aws.pinpoint.model.JourneyStateRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getJourneyId: ZIO[Any, Nothing, __string] = ZIO.succeed(journeyId)
    def getJourneyStateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.JourneyStateRequest.ReadOnly
    ] = ZIO.succeed(journeyStateRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateRequest
  ) extends zio.aws.pinpoint.model.UpdateJourneyStateRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val journeyId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.journeyId())
    override val journeyStateRequest
        : zio.aws.pinpoint.model.JourneyStateRequest.ReadOnly =
      zio.aws.pinpoint.model.JourneyStateRequest
        .wrap(impl.journeyStateRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateRequest
  ): zio.aws.pinpoint.model.UpdateJourneyStateRequest.ReadOnly = new Wrapper(
    impl
  )
}
