package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __boolean}
import scala.jdk.CollectionConverters.*
final case class UpdatePushTemplateRequest(
    createNewVersion: Option[__boolean] = None,
    pushNotificationTemplateRequest: zio.aws.pinpoint.model.PushNotificationTemplateRequest,
    templateName: __string,
    version: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest = {
    import UpdatePushTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest
      .builder()
      .optionallyWith(
        createNewVersion.map(value =>
          __boolean.unwrap(value): java.lang.Boolean
        )
      )(_.createNewVersion)
      .pushNotificationTemplateRequest(
        pushNotificationTemplateRequest.buildAwsValue()
      )
      .templateName(__string.unwrap(templateName): java.lang.String)
      .optionallyWith(
        version.map(value => __string.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdatePushTemplateRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdatePushTemplateRequest.wrap(buildAwsValue())
}
object UpdatePushTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdatePushTemplateRequest =
      zio.aws.pinpoint.model.UpdatePushTemplateRequest(
        createNewVersion.map(value => value),
        pushNotificationTemplateRequest.asEditable,
        templateName,
        version.map(value => value)
      )
    def createNewVersion: Option[__boolean]
    def pushNotificationTemplateRequest
        : zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly
    def templateName: __string
    def version: Option[__string]
    def getCreateNewVersion: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("createNewVersion", createNewVersion)
    def getPushNotificationTemplateRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly
    ] = ZIO.succeed(pushNotificationTemplateRequest)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest
  ) extends zio.aws.pinpoint.model.UpdatePushTemplateRequest.ReadOnly {
    override val createNewVersion: Option[__boolean] = scala
      .Option(impl.createNewVersion())
      .map(value => zio.aws.pinpoint.model.primitives.__boolean(value))
    override val pushNotificationTemplateRequest
        : zio.aws.pinpoint.model.PushNotificationTemplateRequest.ReadOnly =
      zio.aws.pinpoint.model.PushNotificationTemplateRequest
        .wrap(impl.pushNotificationTemplateRequest())
    override val templateName: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.templateName())
    override val version: Option[__string] = scala
      .Option(impl.version())
      .map(value => zio.aws.pinpoint.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdatePushTemplateRequest
  ): zio.aws.pinpoint.model.UpdatePushTemplateRequest.ReadOnly = new Wrapper(
    impl
  )
}
