package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateSegmentRequest(
    applicationId: __string,
    segmentId: __string,
    writeSegmentRequest: zio.aws.pinpoint.model.WriteSegmentRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest = {
    import UpdateSegmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest
      .builder()
      .applicationId(__string.unwrap(applicationId): java.lang.String)
      .segmentId(__string.unwrap(segmentId): java.lang.String)
      .writeSegmentRequest(writeSegmentRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateSegmentRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateSegmentRequest.wrap(buildAwsValue())
}
object UpdateSegmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateSegmentRequest =
      zio.aws.pinpoint.model.UpdateSegmentRequest(
        applicationId,
        segmentId,
        writeSegmentRequest.asEditable
      )
    def applicationId: __string
    def segmentId: __string
    def writeSegmentRequest: zio.aws.pinpoint.model.WriteSegmentRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getSegmentId: ZIO[Any, Nothing, __string] = ZIO.succeed(segmentId)
    def getWriteSegmentRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.WriteSegmentRequest.ReadOnly
    ] = ZIO.succeed(writeSegmentRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest
  ) extends zio.aws.pinpoint.model.UpdateSegmentRequest.ReadOnly {
    override val applicationId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.applicationId())
    override val segmentId: __string =
      zio.aws.pinpoint.model.primitives.__string(impl.segmentId())
    override val writeSegmentRequest
        : zio.aws.pinpoint.model.WriteSegmentRequest.ReadOnly =
      zio.aws.pinpoint.model.WriteSegmentRequest
        .wrap(impl.writeSegmentRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest
  ): zio.aws.pinpoint.model.UpdateSegmentRequest.ReadOnly = new Wrapper(impl)
}
